//
//  CMSLoginViewController.h
//  Composr Mobile SDK
//
//  Created by Aaswini on 04/08/14.
//  Copyright (c) 2014 Aaswini. All rights reserved.
//
import UIKit
let STORYBOARD_ID_CMSLoginViewController = "CMSLoginViewController"
protocol CMS_LoginViewController_Delegate: NSObject {
    func didLogin()

    func didFailToLogin()
}
class CMSLoginViewController: UIViewController, UITextFieldDelegate, CMSNetworkManager_LoginDelegate {
    @IBOutlet var lblUsername: UILabel!
    @IBOutlet var lblPassword: UILabel!
    @IBOutlet var txtUsername: UITextField!
    @IBOutlet var txtPassword: UITextField!
    @IBOutlet var btnLogin: UIButton!
    weak var delegate: CMS_LoginViewController_Delegate?

    @IBAction func doLogin(sender: AnyObject) {
        self.executeLogin()
    }


    convenience override init() {
        var storyboard = UIStoryboard(name: CMS_STORYBOARD_NAME, bundle: nil)
        self = storyboard.instantiateViewControllerWithIdentifier(STORYBOARD_ID_CMSLoginViewController)
    }

    override func viewDidLoad() {
        super.viewDidLoad()
        self.title = "Login"
        if self.isPresentedAsModal() {
            var cancelButtonItem = UIBarButtonItem(barButtonSystemItem: .Cancel, target: self, action: (self.cancel))
            self.navigationItem.leftBarButtonItem! = cancelButtonItem
        }
        self.lblUsername.text = CMS_Langs.do_lang(LABEL_LOGIN_USERNAME)
        self.lblPassword.text = CMS_Langs.do_lang(LABEL_LOGIN_PASSWORD)
        self.btnLogin.setTitle(CMS_Langs.do_lang(BUTTON_LOGIN_LOGIN), forState: .Normal)
    }

    func isPresentedAsModal() -> Bool {
        var isModal = (self.parentViewController! && self.parentViewController!.modalViewController == self) ||             //or if I have a navigation controller, check if its parent modal view controller is self navigation controller
(self.navigationController! && self.navigationController!.parentViewController! && self.navigationController!.parentViewController!.modalViewController == self.navigationController!) ||             //or if the parent of my UITabBarController is also a UITabBarController class, then there is no way to do that, except by using a modal presentation
(self.tabBarController!.parentViewController! is UITabBarController)
        //iOS 5+
        if !isModal && self.respondsToSelector((self.presentingViewController)) {
            isModal = (self.presentingViewController && self.presentingViewController.modalViewController == self) ||             //or if I have a navigation controller, check if its parent modal view controller is self navigation controller
(self.navigationController! && self.navigationController!.presentingViewController && self.navigationController!.presentingViewController.modalViewController == self.navigationController!) ||             //or if the parent of my UITabBarController is also a UITabBarController class, then there is no way to do that, except by using a modal presentation
(self.tabBarController!.presentingViewController! is UITabBarController)
        }
        return isModal
    }

    @IBAction func cancel(sender: AnyObject) {
        if self.delegate != nil && self.delegate.respondsToSelector((self.didFailToLogin)) {
            self.delegate.didFailToLogin()
        }
        else {
            CMS_Flow.warn_screen("Login Cancelled", self)
        }
    }

    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
    }

    func executeLogin() {
        if !self.validateLoginFields() {
            var alert = UIAlertView(title: "Required Fields", message: "Username and password must both be filled in", delegate: self, cancelButtonTitle: "Ok")
            alert.show()
            return
        }
        CMSNetworkManager.sharedManager().loginDelegate = self
        CMSNetworkManager.sharedManager().loginWithUsername(txtUsername.text, password: txtPassword.text, onCompletion: nil, onFaillure: nil, showLoader: true)
    }

    func validateLoginFields() -> Bool {
        if (txtUsername.text == "") || (txtPassword.text == "") {
            return false
        }
        return true
    }
// MARK: - TextFieldDelegate Methods

    func textFieldShouldReturn(textField: UITextField) -> Bool {
        if textField == self.txtUsername {
            self.txtPassword.becomeFirstResponder()
        }
        else if textField == self.txtPassword {
            textField.resignFirstResponder()
        }

        return true
    }
// MARK: - CMSNetworkManager_LoginDelegate Methods

    func CMSNetworkManager(manager: CMSNetworkManager, didLoginWithResponse response: [NSObject : AnyObject]) {
        print("\(response)")
        if self.delegate != nil && self.delegate.respondsToSelector((self.didLogin)) {
            self.delegate.didLogin()
        }
        else {
            CMS_Flow.inform_screen("Login Successful", self)
            print("\(NSUserDefaults.standardUserDefaults().dictionaryRepresentation())")
        }
    }

    func CMSNetworkManager(manager: CMSNetworkManager, didFailToLoginWithError error: NSError?) {
        if self.delegate != nil && self.delegate.respondsToSelector((self.didFailToLogin)) {
            self.delegate.didFailToLogin()
        }
        else {
            CMS_Flow.warn_screen("Login Failed with Error : \(error.domain)", self)
        }
    }
}

let LABEL_LOGIN_USERNAME = "LABEL_LOGIN_USERNAME"
let LABEL_LOGIN_PASSWORD = "LABEL_LOGIN_PASSWORD"
let BUTTON_LOGIN_LOGIN = "BUTTON_LOGIN_LOGIN"